<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\BaseController;
use app\model\ShCourse as ShCourseModel;
use app\Request;

class ShCourse extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //机构课程列表
    public function getShCourseList(Request $request)
    {
        $parm = $request->param();
        $where = ['is_del' => 0, 'user_id' => $request->userId];
        $map = [];
        if (isset($parm['searchKeyWords']) && $parm['searchKeyWords']) {
            $map[] = ['title', 'like', '%' . $parm['searchKeyWords'] . '%'];
        }
        if (isset($parm['status']) && $parm['status']) {
            $map[] = ['status', '=', $parm['status']];
        }
        if (isset($parm['cate_id']) && $parm['cate_id']) {
            $map[] = ['cate_id', '=', $parm['cate_id']];
        }
        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);
        $list = ShCourseModel::where($where)->where($map)
            ->field('id,title,createtime,thumb,tag_ids,price,status,is_sell,is_del,tvclick,click,cate_id,teacher_id')
            ->order('createtime desc')
            ->append(['thumbpath','cate_name','tag_title','teacher_name','status_text'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        return $this->returnMsg('success', 1, $list);
    }



}