<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use app\model\project\User;
use app\model\system\SystemUploadFile;
use think\facade\Db;
use think\Model;
use think\model\concern\SoftDelete;

/**
 * 课程模型
 */
class Project extends Model
{

    use SoftDelete;
    protected $deleteTime = 'deletetime';
    public function getCreatetimeAttr($value)
    {
        return date('Y-m-d H:i:s', $value);
    }


    public function projectcatedata()
    {

        return $this->hasOne(ProjectCategory::class, 'id', 'cate_id')
            ->field('id,title');

    }

    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }

    public function getShStatusTextAttr($value, $data)
    {
        switch ($data['sh_status']) {
            case 1:
                $statustxt = '审核失败';
                break;
            case 2:
                $statustxt = '审核成功';
                break;
            default:
                $statustxt = '待审核';
        }

        return $statustxt;
    }

    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {
            case 1:
                $statustxt = '招募中';
                break;
            case 2:
                $statustxt = '进行中';
                break;
            case 3:
                $statustxt = '待验收';
                break;
            case 4:
                $statustxt = '已完成';
                break;
            case 5:
                $statustxt = '已取消';
                break;
            default:
                $statustxt = '等待审核';
        }

        return $statustxt;
    }

}