<?php

namespace app\subscribe;

use app\job\Jobtask;
use think\Event;
use think\facade\Db;
use think\facade\Log;
use think\facade\Queue;

use app\model\ShCourse;
use app\model\ShCourseClass;
use app\model\ShCourseClassCategory;


use app\model\Course as CourseModel;
use app\model\CourseClassCategory;
use app\model\CourseClass;
use app\model\ShCourseWork;
use app\model\CourseWork;

class course
{

    public function onCourse($event)
    {
        Queue::push(Jobtask::class, $event); // 推送到队列的任务类及其数据参数
//        $this->synccourse($event);
    }

    public function subscribe(Event $event)
    {
        $event->listen('Course', [__CLASS__, 'onCourse']);

    }


    public function synccourse($data)
    {

        if ($data['action'] == 'shstatus') {
            //更新课程
            $courseinfo = ShCourse::where('id', $data['course_id'])->find();
            $is_cz = CourseModel::where('id', $data['course_id'])->count();
            if ($is_cz > 0) {
                unset($courseinfo['click']);
                unset($courseinfo['tvclick']);
                CourseModel::update($courseinfo);
            } else {
                CourseModel::create($courseinfo); //添加课程
            }

            //处理课时
//            $course_class_list = ShCourseClass::where('course_id', $data['course_id'])->without(['tvfile'])->select();
            $course_class_list = Db::name('sh_course_class')->where('course_id', $data['course_id'])->select()->toArray();

            if ($course_class_list) {
//                CourseClass::where('course_id', $data['course_id'])->delete(); //删除课时
                CourseClass::saveAll($course_class_list); //添加课时
            }


            //处理章节
//            $course_class_category = ShCourseClassCategory::where('course_id', $data['course_id'])->select()->toArray();
            $course_class_category = Db::name('sh_course_class_category')->where('course_id', $data['course_id'])->select()->toArray();
            if ($course_class_category) {
//                CourseClassCategory::where('course_id', $data['course_id'])->delete(); //删除章节
                CourseClassCategory::saveAll($course_class_category); //添加章节
            }

            //处理作业
//            $course_work = ShCourseWork::where('course_id', $data['course_id'])->select()->toArray();
            $course_work = Db::name('sh_course_work')->where('course_id', $data['course_id'])->select()->toArray();
            if ($course_work) {
//                CourseWork::where('course_id', $data['course_id'])->delete(); //删除作业
                CourseWork::saveAll($course_work); //添加作业
            }


        } elseif ($data['action'] == 'shcourseupdate') {

            //更新状态数据 删除，上下架
            $courseinfo = Db::name('sh_course')->field('id,is_sell,is_del,is_hot,is_tj')->where('id', $data['course_id'])->find();
            Db::name('course')->where('id', $data['course_id'])->update($courseinfo);
            //处理课时
            $course_class_list = Db::name('sh_course_class')->field('id,is_del,is_sell,sort')->where('course_id', $data['course_id'])->select()->toArray();
            foreach ($course_class_list as $item) {
                Db::name('course_class')->update($item);
            }
            //处理章节
            $course_class_category = Db::name('sh_course_class_category')->field('id,is_del,sort')->where('course_id', $data['course_id'])->select()->toArray();

            foreach ($course_class_category as $item) {
                Db::name('course_class_category')->update($item);
            }
            //处理作业
            $course_work = Db::name('sh_course_work')->field('id,is_del')->where('course_id', $data['course_id'])->select()->toArray();
            foreach ($course_work as $item) {
                Db::name('course_work')->update($item);
            }

        } elseif ($data['action'] == 'courseupdateclick') {
            //更新销量阅读量
            $courseinfo = CourseModel::field('id,click,tvclick')->where('id', $data['course_id'])->find();
            ShCourse::update($courseinfo);
        }


    }

}