<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller;

use app\model\system\SystemDict as Dict;
use app\model\system\SystemMenus as Menus;
use app\model\system\SystemCategory as Category;
use think\App;
use think\facade\Db;
use app\model\ArticleModel;
use tool\Tree;
/**
 * 后台主控制器
 */
class Article extends AdminBase
{

    protected $article;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->article = new ArticleModel();

    }

    //文章列表
    public function index(string $do='')
    {
        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['page'] = isset($post['page']) ? $post['page'] : 1;
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];
            $list = $this->article->where($map)->page($post['page'], $post['limit'])->select()->append(['cate_name','adminname'])->toArray();

            return  $this->returnMsg('',0,$list);
        }
        $category = Db::name('article_category')->field('*,pid as parentid')->order('sort desc')->select()->toArray();
        $this->assign('category', json_encode($category));
        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //编辑新增文章
    public function edit()
    {

        if($this->request->isPost()){

            $post = input();
            print_r($post);exit;
        }
        $category = Db::name('article_category')->order('sort desc')->select()->toArray();
        $tree       = new Tree();
        $tree->icon = ['&nbsp;&nbsp;│ ', '&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;└─ '];
        $tree->nbsp = '&nbsp;&nbsp;';
        $str        = "<option value=@id @selected @disabled>@spacer @title</option>";
        $tree->init($category);
        $categorydata = $tree->getTree(0, $str, 0);
        $this->assign('categorydata', $categorydata);
        return $this->fetch('', '', false);
    }

    public function maind()
    {

        return $this->fetch('', '', false);
    }


}