<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\caiwu;

use app\admin\controller\AdminBase;
use think\App;
use think\facade\Db;
use app\model\project\UserWithdrawal;

/**
 * 后台主控制器
 */
class Withdrawal extends AdminBase
{

    protected $withdrawal;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->withdrawal = new UserWithdrawal();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map = [];
            $hasmap = [];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['title', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['cate_id']) && !empty($post['cate_id'])) {
                $map[] = ['cate_id', '=', $post['cate_id']];
            }

            $list = $this->withdrawal->where($map)->with(['getuserdata'])->append(['sh_status_text','dk_status_text'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }
        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }



    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->withdrawal->destroy([$ids])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }




    //审核
    public function shenhewithdrawal()
    {
        $post = input();
        $errordesc = '';
        $shstatus = 2;
        if ($post['shstatus'] == 1) {
            if (empty($post['errordesc'])) {
                return $this->returnMsg("请输入失败原因");
            }
            $errordesc = $post['errordesc'];
            $shstatus = 1;
        }
        $updatedata['sh_status'] = $shstatus;
        $updatedata['sh_status_desc'] = $errordesc;

        $result = $this->withdrawal->where('id', $post['id'])->update($updatedata);
        if ($result) {
            return $this->returnMsg("操作成功", 1);
        } else {
            return $this->returnMsg("操作失败");
        }

    }
    //打款
    public function dakuanwithdrawal()
    {
        $post = input();
        $errordesc = '';
        $shstatus = 3;
        if ($post['shstatus'] == 2) {
            if (empty($post['errordesc'])) {
                return $this->returnMsg("请输入失败原因");
            }
            $errordesc = $post['errordesc'];
            $shstatus = 2;
        }
        $updatedata['dk_status'] = $shstatus;
        $updatedata['dk_status_desc'] = $errordesc;
        $updatedata['dk_time'] = time();

        $result = $this->withdrawal->where('id', $post['id'])->update($updatedata);
        if ($result) {
            return $this->returnMsg("操作成功", 1);
        } else {
            return $this->returnMsg("操作失败");
        }

    }
}