<?php

namespace app\api\validate;

use think\Validate;

class ShCourseClassValidate extends BaseValidate
{
    protected $rule = [
        'cate_id' => 'require',
        'course_id' => 'require',
        'title' => 'require',
        'tv_file' => 'require',
        'tvtime' => 'require',
        'course_class_id' => 'require',
        'updateField' => 'require|in:sort,is_sell',
        'updateValue' => 'require',

    ];
    protected $message = [
        'cate_id.require' => '请选择章节',
        'course_id.require' => '请选择课程',
        'title.require' => '课时名称不能为空',
        'tv_file.require' => '请上传视频',
        'tvtime.require' => '视频长度不能为空',
        'course_class_id.require' => '课时ID不能为空',
        'updateField.require' => '必填项不能为空',
        'updateValue.require' => '必填项不能为空',
        'updateField.in' => '范围不合法',


    ];

}