<?php

namespace app\admin\controller;

use app\admin\validate\AdvertValidate;
use think\App;
use app\model\project\Advert as AdvertModel;
use app\model\project\AdvertCate;

class Advert extends AdminBase
{
    protected $advert;

    public function __construct(App $app)
    {
        parent::__construct($app);
        $this->advert = new AdvertModel();

    }

    //广告列表
    public function index(string $do = '')
    {
        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['name', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['p_id']) && !empty($post['p_id'])) {
                $map[] = ['p_id', '=', $post['p_id']];
            }
            $list = $this->advert->with(['coverImg'])->append(['advcatename'])->where($map)->paginate($post['limit']);
            return $this->returnMsg($list);
        }
        $categorydata = AdvertCate::where('is_del',0)->select()->toArray();
        $this->assign('categorydata', $categorydata);
        $this->assign('limit', $limit);
        $this->assign('get', input());
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {
        $post = input();
        $result = $this->advert->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改失败');
        }
    }
    //编辑新增广告
    public function edit()
    {
        $post = input();
        if ($this->request->isPost()) {

            $check = (new AdvertValidate())->goCheck();
            if ($check !== true) {
                return $check;
            }
            try {
                if ($post['id'] > 0) {
                    $msg = '更新成功';
                    $this->advert->update($post, ['id' => $post['id']]);
                } else {
                    $post['create_time'] = time();
                    unset($post['id']);
                    $msg = '添加成功';
                    $this->advert->save($post);
                }
            } catch (\Exception $e) {

                return $this->returnMsg($e->getMessage(), 0);
            }
            return $this->returnMsg($msg, 1);

        }
        $data = $this->advert->find($post['id']);
        $categorydata = AdvertCate::select()->toArray();
        $this->assign('categorydata', $categorydata);
        $this->assign('data', $data);
        return $this->fetch('', '', false);
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->advert->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


}