<?php

namespace app\api\validate;


class StudyInformationValidate extends BaseValidate
{
    protected $rule = [
        'study_information_id' => 'require',
        'title' => 'require',
        'type' => 'require',
        'cate_id' => 'require',
        'price' => 'between:0,99999',
        'file_id' => 'requireCallback:filecontentcheck',
        'content' => 'requireCallback:contentcheck',
        'updateField' => 'require|in:is_sell',
        'updateValue' => 'require',
        'pid' => 'require',

    ];
    protected $message = [
        'study_information_id.require' => '资料id不能为空',
        'title.require' => '标题不能为空',
        'cate_id.require' => '请选择分类',
        'type.require' => '请选择类型',
        'price.between' => '金额错误',
        'file_id.requireCallback' => '请上传文件',
        'content.requireCallback' => '请填写内容',
        'updateField.require' => '必填项不能为空',
        'updateValue.require' => '必填项不能为空',
    ];


    protected function filecontentcheck($value, $data=[])
    {
        if ($data['type'] != 'content') {
            return true;
        }
    }

    protected function contentcheck($value, $data=[])
    {

        if ($data['type'] == 'content') {
            return true;
        }

    }

}