<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\service\UtilService;
use app\BaseController;
use app\model\ProjectTag;
use think\facade\Db;
use think\Request;

class Index extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //看板统计
    public function index(Request $request)
    {
        $userId = $request->userId;

        try {
            Db::startTrans();

            // 1. 获取基础数据
            $courseStats = Db::name('course')
                ->where('user_id', $userId)
                ->field([
                    'COUNT(id) as course_count',
                    'SUM(tvclick) as pv_count',
                    'GROUP_CONCAT(id) as course_ids'
                ])
                ->find();

            $courseIds = $courseStats['course_ids'] ? explode(',', $courseStats['course_ids']) : [];

            // 2. 获取支付相关统计数据
            $paymentStats = Db::name('payment')
                ->where('order_id', 'in', $courseIds)
//                ->where('sf_id', 'in', $courseIds)

                ->where('order_type', 1)
                ->field([
                    'SUM(CASE WHEN pay_status = 1 THEN pay_amount ELSE 0 END) as order_money_sum',
                    'COUNT(id) as order_count'
                ])
                ->find();

            // 3. 获取项目统计数据
            $projectStats = Db::name('project')
                ->where('user_id', $userId)
                ->field([
                    'COUNT(id) as project_count',
                    'SUM(CASE WHEN status IN (0,1,3) THEN 1 ELSE 0 END) as project_pending_count',
                    'SUM(CASE WHEN status = 2 THEN 1 ELSE 0 END) as project_progress_count',
                    'SUM(CASE WHEN status = 4 THEN 1 ELSE 0 END) as project_finished_count'
                ])
                ->find();

            // 组装返回数据
            $result = [
                'orderMoneySum' => (int)$paymentStats['order_money_sum'] ?? 0,
                'orderCount' => (int)$paymentStats['order_count'] ?? 0,
                'courseCount' => (int)$courseStats['course_count'] ?? 0,
                'pvCount' => (int)$courseStats['pv_count'] ?? 0,
                'projectCount' => (int)$projectStats['project_count'] ?? 0,
                'projectPendingCount' => (int)$projectStats['project_pending_count'] ?? 0,
                'projectProgressCount' => (int)$projectStats['project_progress_count'] ?? 0,
                'projectFinishedCount' => (int)$projectStats['project_finished_count'] ?? 0,
//                'projectPendingList'=>$this->getProjectPendingList($userId)
            ];

            Db::commit();

            return $this->returnMsg('success', 1,$result);

        } catch (\Exception $e) {
            Db::rollback();
            return $this->returnMsg('系统错误，请稍后再试');
        }
    }

    public function getProjectPendingList(Request $request)
    {
        $userId = $request->userId;
        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);


        // 1. 查询项目列表
        $projects = \app\model\Project::where('user_id', $userId)
            ->where('status', 'in', [0, 1, 3])
            ->withCount(['put'])
            ->field([
                'id',
                'title',
                'status',
                'tag_ids',
                'sh_status_time',
                'zhouqi',
                // 当 status=3 时，计算截止日期（sh_status_time + zhouqi * 86400）
                'IF(
                    status=3 AND sh_status_time IS NOT NULL AND zhouqi IS NOT NULL, 
                    FROM_UNIXTIME(sh_status_time + zhouqi * 86460), 
                    NULL
                ) as deadline_date',
            ])
            ->paginate([
                'page' => $page,      // 当前页数
                'list_rows' => $pageSize, // 每页数量
            ]);

        $list = UtilService::listWithTags($projects,ProjectTag::class,'tag_ids');

        return $this->returnMsg('success', 1, $list);
    }
}