<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;
use app\model\project\User;
use app\model\system\SystemUploadFile;
use think\Model;

/**
 * 课程模型
 */
class CertOrder extends Model
{

    public function certdata()
    {
        return $this->hasOne(Cert::class, 'id', 'cert_id')
            ->field('id,title,price');

    }

    public function certfiledata()
    {

        return $this->hasOne(CertFile::class, 'cert_order_id', 'id')
            ->field('id,file_id,cert_order_id');

    }

    public function userprofile()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')
            ->field('id,username,mobile');
    }

    public function getOtherFileListAttr($value, $data)
    {
        return get_upload_file($data['other_file_id'],'list');
    }
    public function getCreatetimeAttr($value)
    {
        return date('Y-m-d H:i:s', $value);
    }
    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {
            case 2:
                $statustxt = '申请失败';
                break;
            case 3:
                $statustxt = '申请成功';
                break;
            default:
                $statustxt = '申请中';
        }
        return $statustxt;
    }

    //最新认证动态
    public function latestCertList($page,$pageSize)
    {
        $where = ['status'=>3,'is_del'=>0];
        
      

        $list = self::where($where)
            ->with(['user'=>['headico'],'cert'])
            ->order('createtime','desc')
            ->field('id,cert_id,user_id,name,updatetime')
            ->append(['updatetime_text'])
            
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);

        // $list->each(function($item) {
        //     $item->append(['updatetime_text']);
        //     return $item;
        // });
  
        return $list;
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id')->field('id,username,headico');
    }

    public function cert()
    {
        return $this->hasOne(Cert::class, 'id', 'cert_id')->field('id,title,fzjg');
    }

    public function getUpdatetimeTextAttr($value, $data)
    {
        $timestamp = is_numeric($data['updatetime']) ? $data['updatetime'] : strtotime($data['createtime']);
        return $this->timeElapsedString($timestamp);
    }

    protected function timeElapsedString($timestamp)
    {
        $currentTime = time();
        $timeDiff = $currentTime - $timestamp;

        if ($timeDiff < 60) {
            return '刚刚';
        } elseif ($timeDiff < 3600) {
            return floor($timeDiff / 60) . '分钟前';
        } elseif ($timeDiff < 86400) {
            return floor($timeDiff / 3600) . '小时前';
        } elseif ($timeDiff < 2592000) {
            return floor($timeDiff / 86400) . '天前';
        } elseif ($timeDiff < 31536000) {
            return floor($timeDiff / 2592000) . '个月前';
        } else {
            return floor($timeDiff / 31536000) . '年前';
        }
    }

    public function idcardQ()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'idcard_q')
            ->where('isdel',0)
            ->field('fileid,filename,filesize,fileurl,filetype,storage');
    }

    public function idcardH()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'idcard_h')
            ->where('isdel',0)
            ->field('fileid,filename,filesize,fileurl,filetype,storage');
    }

    public function headImg()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'head_img_id')
            ->where('isdel',0)
            ->field('fileid,filename,filesize,fileurl,filetype,storage');
    }




}