<?php

namespace app\api\controller;

use app\api\middleware\Auth;
use app\api\service\TokenService;
use app\api\service\UserService;
use app\api\validate\BusinessValidate;
use app\api\validate\SchoolValidate;
use app\BaseController;
use app\model\project\School as schoolModel;
use app\model\project\User as userModel;
use app\Request;
use think\facade\Cache;

/**
 * 入驻
 */
class Settled extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    /**高校入驻
     *
     */
    public function school(Request $request)
    {
        $vo = (new SchoolValidate())->goCheck();
        if ($vo !== true) {
//            return $vo;
        }

        $data = $request->param();
        $token = $request->header('token');

        $user  = UserService::getUserInfo($token);
        if (!$user)
        {
            return $this->returnMsg('token无效',0);
        }

        if (schoolModel::where('user_id', $user['id'])->count())
        {
            return $this->returnMsg('请勿重复提交',0);
        }


        $data['user_id'] = $user['id'];

        schoolModel::create($data);

        userModel::where('id',$user['id'])->update(['role'=>3]);

        return $this->returnMsg('操作成功',1);
    }


    /**企业
     *
     */
    public function business()
    {
        $vo = (new BusinessValidate())->goCheck();
        if ($vo !== true) {
            return $vo;
        }
    }

}