<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;


use app\model\project\User;
use think\facade\Db;
use think\Model;

/**
 * 课时模型
 */
class ShCourseClass extends Model
{


    public function getCreatetimeAttr($value)
    {
        return date('Y-m-d H:i:s', $value);
    }

    //课程名称
    public function getCourseTitleAttr($value, $data)
    {
        return ShCourse::where('id', $data['course_id'])->value('title');
    }

    public function getUserInfoAttr($value, $data)
    {
        return User::where('id', $data['user_id'])->field('id,username,mobile')->find();
    }

    //章节名称
    public function getCourseClassCateAttr($value, $data)
    {
        $title = ShCourseClassCategory::where('id', $data['cate_id'])->value('title');
        return $title ? $title : '无';
    }
    //试看
    public function getIssktextAttr($value, $data){

        return $data['is_sk'] == 1 ? '是' : '否';
    }

    //视频地址
    public function getTvfilepathAttr($value, $data)
    {
        return get_upload_file($data['tv_file']);
    }

    //视频地址
    public function getTvfileAttr($value, $data)
    {
        return get_upload_file($data['tv_file'],'info');
    }
}