<?php

namespace app\model;

use think\Model;

class CourseCommentReport extends Model
{
    // 设置表名
    protected $table = 'fj_course_comment_reports';
    
    // 设置时间字段
    protected $autoWriteTimestamp = true;
    protected $createTime = 'createtime';
    protected $updateTime = 'updatetime';
    
    // 设置字段
    protected $schema = [
        'id'          => 'int',
        'comment_id'  => 'int',
        'user_id'     => 'int',
        'reason'      => 'string',
        'status'      => 'int',
        'createtime'  => 'int',
        'updatetime'  => 'int'
    ];

    // 关联评论
    public function comment()
    {
        return $this->belongsTo(CourseComment::class, 'comment_id', 'id');
    }

    // 关联用户
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
} 