<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;


use app\model\project\User;
use think\facade\Db;
use think\Model;

/**
 * 课程模型
 */
class ShCourse extends Model
{


    public function getCreatetimeAttr($value)
    {
        return date('Y-m-d H:i:s', $value);
    }

    public function getThumbpathAttr($value, $data)
    {
        return get_upload_file($data['thumb']);
    }

    public function getCateNameAttr($value, $data)
    {

        return CourseCategory::where('id', $data['cate_id'])->value('title');
    }

    public function getDetailthumbpathAttr($value, $data)
    {
        return get_upload_file($data['detailthumb']);
    }

    public function getTeacherNameAttr($value, $data)
    {
        return CourseTeacher::where('id', $data['teacher_id'])->value('nickname');
    }

    public function getTagTitleAttr($value, $data)
    {
        return implode(',', CourseTag::where('id', $data['tag_ids'])->column('title'));
    }

    public function getStatusTextAttr($value, $data)
    {
        switch ($data['status']) {
            case 1:
                $statustxt = '待审核';
                break;
            case 2:
                $statustxt = '审核失败';
                break;
            case 3:
                $statustxt = '审核成功';
                break;
            default:
                $statustxt = '待提交';
        }

        return $statustxt;
    }

    public function getUserInfoAttr($value, $data)
    {
        return User::where('id', $data['user_id'])->field('id,username,mobile')->find();
    }

    //上架状态
    public function getIsSellTextAttr($value, $data)
    {

        switch ($data['is_sell']) {
            case 1:
                $selltext = '已上架';
                break;
            default:
                $selltext = '已下架';
                break;
        }


        return $selltext;
    }

}