<?php
/**
 * This file is part of Swoole.
 *
 * @link     https://www.swoole.com
 * @contact  team@swoole.com
 * @license  https://github.com/swoole/library/blob/master/LICENSE
 */

declare(strict_types=1);

namespace Swoole\Coroutine\Http;

class ClientProxy
{
    private array $headers;

    private array $cookies;

    public function __construct(private string $body, private int $statusCode, ?array $headers, ?array $cookies)
    {
        $this->headers = $headers ?? [];
        $this->cookies = $cookies ?? [];
    }

    public function getBody(): string
    {
        return $this->body;
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    public function getCookies(): array
    {
        return $this->cookies;
    }
}
