<?php
/* *
 * 功能：支付宝电脑网站支付
 * 版本：2.0
 * 修改日期：2017-05-01
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 */

namespace app\api\service;


require_once ROOT_PATH . 'extend/aop/AopClient.php';
require_once ROOT_PATH . 'extend/aop/request/AlipayTradePagePayRequest.php';

class AlipayTradeService22
{

    //支付宝网关地址
    public $gateway_url = "https://openapi.alipay.com/gateway.do";

    //支付宝公钥
    public $alipay_public_key;

    //商户私钥
    public $private_key;

    //商户私钥路径
    public $rsaPrivateKeyFilePath;
    //支付宝公钥路径
    public $alipayPublicKey;
    //应用id
    public $appid = '2021005147679343';

    //编码格式
    public $charset = "UTF-8";

    public $token = NULL;

    //返回数据格式
    public $format = "json";

    //签名方式
    public $signtype = "RSA2";

    //日志路径
    public $log_path;

    function __construct($alipay_config)
    {

        $this->gateway_url = isset($alipay_config['gatewayUrl']) ?: $this->gateway_url;
        $this->appid = isset($alipay_config['app_id']) ?: $this->appid;
        $this->private_key = 'MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCMfJB8oXmmAeTxhUfnDnoxQF1uUgIGC9akVuv6Y0OsKfzos0i1zvNB7TzEcFC73CdAUeRBSF34+CFuxJwtRxZcsjeginGUoCGUkal6I7Wos/CtkeqEN/9PSsD0VqZCklNBpmzZZKEyQxoLMyiYNP2mzjZnehTkyzrniKhdp+xrGF+FBS1SdM4pLEB+zkLQ+Mh17D5tLAHe9ceVI4H+F/1SEiGkjvYZJ1k00YNrLhenzatNfoKCcJjskrIkIy5P7Lyddau54mnl8mApLvaKxt2GIG7X/QwI6kTtL270iughIOScX4Wf89ONgp2EZAztaIWBq58GwtQu95WnhrPqz95DAgMBAAECggEBAIh/22+NAYKf4pAc3PEOqwFBtcYkHl07kXEaF6ywWCdmoJqE4EfubYMH+/wt2PO/A9BGAU7A/rWSegGDPO/tWzfz3YK6IYO0Vwxgv1eybKYfN+GdnkybkBC95F9D9cVHIWfvSWGsmccZVau+KFpDWpWBVXETOEvZf0FKEbT2HQssKFLhGTz2Hwyv2y5QO9yhIMj644M6XadqzpHIl3WNL4V9yVl8kZ5wAkyT7GUWbXP5AdDYW2m+FOPuyqJmfP3XJcPFTkMOa6a9MU6fjZ9cQ/n67Tmdu0p3rJruMw+vxZAltlwoDNfrhgtGNMSoK0fDjiXEEPRq8dDrR+TFxbMSi2kCgYEA7eISGUasOnbuh0ObuKnmUfZNl6A8jb10AJUAisf+q2t7rrs7T5jBuau1Bxg/YSg/iJo0oPo7wkhN8mS8dNUPYjVNc2Cn04sBl93pOGEIRhyC8o2ePCgf6oJs1W8IMnHm/hGM/CMpxdOUP+6KEOa9Rmc2/j5Y8INDBhgzqDFQnz0CgYEAly+V6mhbdlMlQrhvkittFzJ1qaiShF6lSeMBQjJ7aSKiLTwUqwlSTX/MpI4RUDdpzQ+LpuI3/ODrgBTiWttpTx9LCBuOC7Llp2/bjc2n++ghTEUdsyTvOyQJN1OPJLmnWM2vrFC6vIiIZha8/INFO2QtxYW4sKp1aSt+cFxyS38CgYEAqx/rFyXA9dnio4meNwx5tFJz5PSPOwOjtFt75VoTuOr8MWldNFhWXCPKeU0XIuRaOAF+hKMeZBexgwK2k3FFvMdNbQeGE2a3AbHQeQ9MbWtLRANeZjYTJ5clhbB2/Br2KaUkf6kn/rjCt+74gUoLtN7BL8pYHsS+bV7xoje/oJ0CgYBMlEHvliSd7se04A9DjtOXKGwJH+X3Pqmin2WHzmJMgsp69y/Q4svZjZ5uy7dhVnA0+mbWhUeuw48GNY3iT7kr5sHuvWZZ7qf9A9/GGCG6q34SUAAXOeIjpsE0URL0m0V06drOAaZU0SOl8maP0T5EMx4sKuu+MNmACBPnfiw2qQKBgFxPMuqkhSSUdJn/li6m2PDEQJb8VpWOw1IPvh6kPx34XLgZjI9obty1GNQ3dM8QHzuDZ3lhg255/NctLUJPDXA5seBsOhHFs4xkldCzQW0ImaA1M3Tm/i2Gxo+AYlZlQYa/8gZw5LkyKnb14muCvyMzV4cQnFfvunBpJcyDS+DY';
//        $this->alipay_public_key = 'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjHyQfKF5pgHk8YVH5w56MUBdblICBgvWpFbr+mNDrCn86LNItc7zQe08xHBQu9wnQFHkQUhd+PghbsScLUcWXLI3oIpxlKAhlJGpeiO1qLPwrZHqhDf/T0rA9FamQpJTQaZs2WShMkMaCzMomDT9ps42Z3oU5Ms654ioXafsaxhfhQUtUnTOKSxAfs5C0PjIdew+bSwB3vXHlSOB/hf9UhIhpI72GSdZNNGDay4Xp82rTX6CgnCY7JKyJCMuT+y8nXWrueJp5fJgKS72isbdhiBu1/0MCOpE7S9u9IroISDknF+Fn/PTjYKdhGQM7WiFgaufBsLULveVp4az6s/eQwIDAQAB';

        $this->alipayPublicKey = ROOT_PATH . 'cert/zfbcert/alipayPublicKey.crt';
        $this->charset = $alipay_config['charset'] ?? 'UTF-8';
        $this->signtype = $alipay_config['sign_type'] ?? 'RSA2';
//        $this->log_path = $alipay_config['log_path'];

        if (empty($this->appid) || trim($this->appid) == "") {
            throw new \Exception("appid should not be NULL!");
        }
        if (empty($this->private_key) || trim($this->private_key) == "") {
            throw new \Exception("private_key should not be NULL!");
        }
//        if (empty($this->alipay_public_key) || trim($this->alipay_public_key) == "") {
//            throw new \Exception("alipay_public_key should not be NULL!");
//        }
        if (empty($this->charset) || trim($this->charset) == "") {
            throw new \Exception("charset should not be NULL!");
        }
        if (empty($this->gateway_url) || trim($this->gateway_url) == "") {
            throw new \Exception("gateway_url should not be NULL!");
        }

    }

    /**
     * alipay.trade.page.pay
     * @param $builder 业务参数，使用buildmodel中的对象生成。
     * @param $return_url 同步跳转地址，公网可以访问
     * @param $notify_url 异步通知地址，公网可以访问
     * @return $response 支付宝返回的信息
     */
    function pagePay($biz_content, $notify_url = '', $return_url = '')
    {
        $biz_content = json_encode($biz_content, JSON_UNESCAPED_UNICODE);
        //打印业务参数
        $this->writeLog($biz_content);

        $request = new \AlipayTradePagePayRequest();
        $request->setNotifyUrl($notify_url);
        $request->setReturnUrl($return_url);
        $request->setBizContent($biz_content);

        // 首先调用支付api
        $response = $this->aopclientRequestExecute($request, true);

        // $response = $response->alipay_trade_wap_pay_response;
        return $response;
    }

    /**
     * sdkClient
     * @param $request 接口请求参数对象。
     * @param $ispage  是否是页面接口，电脑网站支付是页面表单接口。
     * @return $response 支付宝返回的信息
     */
    function aopclientRequestExecute($request, $ispage = false)
    {

        $aop = new \AopClient ();
        $aop->gatewayUrl = $this->gateway_url;
        $aop->appId = $this->appid;
        $aop->rsaPrivateKey = $this->private_key;
        $aop->alipayrsaPublicKey = $this->alipay_public_key;
        $aop->apiVersion = "1.0";
        $aop->postCharset = $this->charset;
        $aop->format = $this->format;
        $aop->signType = $this->signtype;
        // 开启页面信息输出
        $aop->debugInfo = true;
        if ($ispage) {
            $result = $aop->pageExecute($request, "post");
            print_r($result);
            exit;
            echo $result;
        } else {
            $result = $aop->Execute($request);
        }

        //打开后，将报文写入log文件
        $this->writeLog("response: " . var_export($result, true));
        return $result;
    }

    /**
     * alipay.trade.query (统一收单线下交易查询)
     * @param $builder 业务参数，使用buildmodel中的对象生成。
     * @return $response 支付宝返回的信息
     */
    function Query($builder)
    {
        $biz_content = $builder->getBizContent();
        //打印业务参数
        $this->writeLog($biz_content);
        $request = new \AlipayTradeQueryRequest();
        $request->setBizContent($biz_content);

        $response = $this->aopclientRequestExecute($request);
        $response = $response->alipay_trade_query_response;
        return $response;
    }

    /**
     * alipay.trade.refund (统一收单交易退款接口)
     * @param $builder 业务参数，使用buildmodel中的对象生成。
     * @return $response 支付宝返回的信息
     */
    function Refund($builder)
    {
        $biz_content = $builder->getBizContent();
        //打印业务参数
        $this->writeLog($biz_content);
        $request = new \AlipayTradeRefundRequest();
        $request->setBizContent($biz_content);

        $response = $this->aopclientRequestExecute($request);
        $response = $response->alipay_trade_refund_response;
        return $response;
    }

    /**
     * alipay.trade.close (统一收单交易关闭接口)
     * @param $builder 业务参数，使用buildmodel中的对象生成。
     * @return $response 支付宝返回的信息
     */
    function Close($builder)
    {
        $biz_content = $builder->getBizContent();
        //打印业务参数
        $this->writeLog($biz_content);
        $request = new \AlipayTradeCloseRequest();
        $request->setBizContent($biz_content);

        $response = $this->aopclientRequestExecute($request);
        $response = $response->alipay_trade_close_response;
        return $response;
    }

    /**
     * 退款查询   alipay.trade.fastpay.refund.query (统一收单交易退款查询)
     * @param $builder 业务参数，使用buildmodel中的对象生成。
     * @return $response 支付宝返回的信息
     */
    function refundQuery($builder)
    {
        $biz_content = $builder->getBizContent();
        //打印业务参数
        $this->writeLog($biz_content);
        $request = new \AlipayTradeFastpayRefundQueryRequest();
        $request->setBizContent($biz_content);

        $response = $this->aopclientRequestExecute($request);
        return $response;
    }

    /**
     * alipay.data.dataservice.bill.downloadurl.query (查询对账单下载地址)
     * @param $builder 业务参数，使用buildmodel中的对象生成。
     * @return $response 支付宝返回的信息
     */
    function downloadurlQuery($builder)
    {
        $biz_content = $builder->getBizContent();
        //打印业务参数
//        $this->writeLog($biz_content);
        $request = new \alipaydatadataservicebilldownloadurlqueryRequest();
        $request->setBizContent($biz_content);

        $response = $this->aopclientRequestExecute($request);
        $response = $response->alipay_data_dataservice_bill_downloadurl_query_response;
        return $response;
    }

    /**
     * 验签方法
     * @param $arr 验签支付宝返回的信息，使用支付宝公钥。
     * @return boolean
     */
    function check($arr)
    {
        $aop = new \AopClient();
        $aop->alipayrsaPublicKey = $this->alipay_public_key;
        $result = $aop->rsaCheckV1($arr, $this->alipay_public_key, $this->signtype);

        return $result;
    }

    /**
     * 请确保项目文件有可写权限，不然打印不了日志。
     */
    function writeLog($text)
    {
        // $text=iconv("GBK", "UTF-8//IGNORE", $text);
        //$text = characet ( $text );
        if (!empty($this->log_path) && trim($this->log_path) != "") {
            file_put_contents($this->log_path, date("Y-m-d H:i:s") . "  " . $text . "\r\n", FILE_APPEND);
        }
    }
}

?>