<?php

namespace app\api\controller\cert;

use app\api\service\TokenService;
use app\api\validate\CertValidate;
use app\BaseController;
use app\model\CertCategory;
use app\model\CertOrder;
use think\Request;
use app\model\Cert as CertModel;

class Cert extends BaseController
{

    //项目分类列表
    public function getCertCategoryList()
    {
        $list = (new CertCategory())->getCertCategoryList();

        return $this->returnMsg('success',1,$list);
    }

    //项目子分类列表
    public function getCertCategoryChildrenList(Request $request)
    {
        $vo = (new CertValidate())->goCheck(['pid']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $list = (new CertCategory())->getCertCategoryList($data['pid']);

        return $this->returnMsg('success',1,$list);
    }

    //项目列表
    public function getCertList(Request $request)
    {
        $vo = (new CertValidate())->goCheck(['category_id','type']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);
        
        $data['category_id'] = $data['category_id'] == 16 ? 0 : $data['category_id'];
        $list = (new CertModel())->getCertList($data['category_id'],$page,$pageSize,$data['type'],$data['searchKeyWords'] ?? null);

        return $this->returnMsg('success',1,$list);
    }

    //认证动态
    public function getLatestCertList(Request $request)
    {

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $list = (new CertOrder())->latestCertList($page,$pageSize)->toArray();
       
        $dd = $list['data'][0];
       
        $list['data'][] = $dd;
        $list['data'][] = $dd;
        $list['data'][] = $dd;
        $list['data'][] = $dd;
        $list['data'][] = $dd;
        $list['data'][] = $dd;
        $list['data'][] = $dd;
        $list['data'][] = $dd;
        $list['data'][] = $dd;
     
        return $this->returnMsg('success',1,$list);
    }

    //详情
    public function getDetailCert(Request $request)
    {
        $vo = (new CertValidate())->goCheck(['cert_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $detail = CertModel::where('id',$data['cert_id'])
            ->append(['starttimetxt','endtimetxt'])
            ->find();
        if ($detail)
        {
            $token = $request->header('token');
            $userId = TokenService::verifyToken($token)['user_id'] ?? 0;

            $detail['is_enroll'] = CertOrder::
                where(['cert_id'=>$data['cert_id'],'user_id'=>$userId,'is_del'=>0])
                ->where('status','<>',2)
                ->count();
        }


        return $this->returnMsg('success',1,$detail);

    }


}