<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use think\facade\Db;
use think\Model;

/**
 * 模型公用类
 */
class Course extends Model
{

    /**获取推荐课程列表
     * @return Course[]|array|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public  function getRecommendList()
    {
        return self::where(['status'=>3,'is_sell'=>1,'is_del'=>0])
            ->order('click,tvclick,createtime','desc')
            ->field('id,thumb,title')
            ->limit(5)
            ->select();
    }

    /**获取分类下的课程列表
     * @param $cate_id
     * @return Course[]|array|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getCourseList($cate_id = 0)
    {
        $where = ['status'=>3,'is_sell'=>1,'is_del'=>0];
        if ($cate_id)
        {
            $where['cate_id'] = $cate_id;
        }

        return self::where($where)
            ->field('id,thumb,title,createtime,description,price,content')
            ->select();
    }

    public function getCouresDetail($course_id = 0)
    {
        $where = ['status'=>3,'is_sell'=>1,'is_del'=>0];
        if ($course_id)
        {
            $where['course_id'] = $course_id;
        }

        return self::where($where)
            ->field('id,thumb,title,createtime,description,price,content,teacher_id,tvclick,click')
            ->find();

    }


}