<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\course;

use app\admin\controller\AdminBase;
use app\model\ShCourse AS ShCourseModel;
use think\App;
use think\facade\Db;
use app\model\CourseCategory as CourseCategoryModel;


/**
 * 后台主控制器
 */
class course extends AdminBase
{

    protected $course;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->course = new ShCourseModel();

    }

    // 课程列表
    public function index(string $do = '')
    {
        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];
            $map[] = ['status', '>', 0];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['title', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['cate_id']) && !empty($post['cate_id'])) {
                $map[] = ['cate_id', '=', $post['cate_id']];
            }
            $list = $this->course->where($map)->append(['thumbpath','cate_name','teacher_name','status_text','tag_title','user_info'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }
        $category = CourseCategoryModel::field('*,pid as parentid')->where('is_del', 0)->order('sort desc')->select()->toArray();
        $this->assign('category', json_encode($category));
        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $this->course->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        return $this->returnMsg('修改成功');
    }



    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->course->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


}