<?php

namespace app\model\project;

use think\Model;
use think\model\concern\SoftDelete;

class Mail extends Model
{
    use SoftDelete;
    protected $deleteTime = 'deletetime';
    protected $autoWriteTimestamp = true;
    protected $createTime = 'createtime';


    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }

    public function getTypeTextAttr($value, $data)
    {
        return $data['type'] == 1 ? '系统通知' : '后台发送';
    }
}