<?php

namespace app\api\controller\project;

use app\api\middleware\Auth;
use app\api\validate\ProjectValidate;
use app\BaseController;
use think\Request;
use app\model\ProjectPut as ProjectPutModel;

class ProjectPut extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];


    public function projectPut(Request $request)
    {

        $vo = (new ProjectValidate())->goCheck(['project_id','user_desc','file_id_str']);
        if ($vo !== true) {
            return $vo;
        }

        $data = $request->only(['project_id','user_desc','file_id_str']);

        $count = ProjectPutModel::where(['project_id'=>$data['project_id'],'user_id'=>$request->userId])->count();
        if($count)
        {
            return $this->returnMsg('不可重复提交');
        }


        (new ProjectPutModel())->putProject($data,$request->userId);

        return $this->returnMsg('success',1);

    }

}