<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\course;

use app\admin\controller\AdminBase;
use app\model\ShCourse;
use app\model\ShCourseClassCategory AS ShCourseClassCategoryModel;
use think\App;
/**
 * 后台主控制器
 */
class CourseClassCategory extends AdminBase
{

    protected $courseclasscategory;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->courseclasscategory = new ShCourseClassCategoryModel();

    }

    // 课程列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['title', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['kc']) && !empty($post['kc'])) {
                $kcmap[] = ['title', 'like', '%' . $post['kc'] . '%'];
                $kcid_arr = ShCourse::where($kcmap)->column('id');
                if($kcid_arr){
                    $map[] = ['course_id', 'in', $kcid_arr];
                }else{
                    $map[] = ['course_id', 'in', 99999];
                }
            }
            if (isset($post['course_id']) && !empty($post['course_id'])) {
                $map[] = ['course_id', '=', $post['course_id']];
            }



            $list = $this->courseclasscategory->where($map)->append(['course_title','user_info'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $this->courseclasscategory->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        return $this->returnMsg('修改成功');
    }



    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->courseclasscategory->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


}