<?php

namespace app\model\project;

use think\Model;

class UserMoneyLog extends Model
{
    protected $autoWriteTimestamp = true;


    protected $createTime = 'createtime';

    /**
     * 获取用户金额变动排行榜
     * @param int $limit 前N名
     * @param string $timeRange 时间范围: 'all'-全部, 'month'-本月, 'week'-本周, 'day'-今天, 'three_month'-近三月
     * @param int $type 操作类型: null-全部, 0-项目结算, 1-提现, 2-后台手动增加
     * @return array
     */
    public static function getUserMoneyRanking($limit = 10, $timeRange = 'all', $type = null)
    {
        $query = self::field('user_id, SUM(money) as total_money')
            ->group('user_id')
            ->order('total_money', 'DESC')
            ->limit($limit);

        // 按时间范围筛选
        switch ($timeRange) {
            case 'month':
                $query->whereTime('createtime', 'month');
                break;
            case 'week':
                $query->whereTime('createtime', 'week');
                break;
            case 'day':
                $query->whereTime('createtime', 'today');
                break;
            case 'three_month':
                $threeMonthAgo = strtotime('-3 months');
                $query->where('createtime', '>=', $threeMonthAgo);
                break;
        }

        // 按操作类型筛选
        if (!is_null($type)) {
            $query->where('type', $type);
        }

        $ranking = $query->select()->toArray();;


        // 获取用户信息
        if (!empty($ranking)) {
            $userIds = array_column($ranking, 'user_id');
            $users = User::whereIn('id', $userIds)
                ->where('is_del', 0)
                ->column('username,realname,headico', 'id');

            foreach ($ranking as &$item) {
                $item['user_info'] = $users[$item['user_id']] ?? [];
            }
        }

        return $ranking;
    }

}