<?php

namespace app\model;

use app\model\system\SystemUploadFile;
use think\Model;

class CourseClass extends Model
{
    public function fileData()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'tv_file')
            ->where('isdel',0)
            ->field('fileid,filename,filesize,fileurl,filetype,storage');
    }

    public function getTvtimeStrAttr($value,$data)
    {
        if (empty($data['tvtime'])) {
            return null;
        }

        $hours = floor($data['tvtime'] / 3600);
        $minutes = floor(($data['tvtime'] % 3600) / 60);
        $seconds = $data['tvtime'] % 60;

        // 如果小时为0，则只返回 i:s 格式
        if ($hours == 0) {
            return sprintf("%02d:%02d", $minutes, $seconds);
        }

        // 否则返回 H:i:s 格式
        return sprintf("%02d:%02d:%02d", $hours, $minutes, $seconds);
    }

    public function getProgressAttr($value,$data)
    {
        if (empty($data['id'])) {
            return [];
        }

        return CourseProgress::where('class_id', $data['id'])->column('look_tvtime,is_wc_look');

    }

    public function courseProgress()
    {
        return $this->hasOne(CourseProgress::class, 'class_id', 'id');
    }
}