<?php

namespace app\api\validate;

use think\Validate;

class CourseValidate extends BaseValidate
{
    protected $rule = [
        'searchKeyWords' => 'require',
        'category_id' => 'require|number',
        'course_id' => 'require|number',
        'class_id' => 'require|number',
        'current_time' => 'require|number',
        'attachment_ids' => 'require',
        'work_id' => 'require|number',
        'content' => 'require',
        'comment_id' => 'require|number',
        'reason' => 'require|length:1,255',
        'pid'=>'require|number',
    ];

    protected $message = [
        'name.require' => '名称必须',
        'mobile.require' => '手机号不能为空',
        'mobile.mobile' => '手机号格式不正确',
        'password.require' => '密码必须',
        'code.require' => '验证码必须',
        'token.require' => 'token必须',
        'str.require' => '必填项不能为空',
        'confirm_password.checkPasswordEqual' => '两次输入的密码不一致',
        'reason.require' => '举报原因不能为空',
        'reason.length' => '举报原因长度必须在1-255个字符之间'
    ];

    protected $scene = [
        'searchKeyWords' => ['searchKeyWords'],
        'category_id' => ['category_id'],
        'course_id' => ['course_id'],
        'class_id' => ['class_id'],
        'current_time' => ['current_time'],
        'attachment_ids' => ['attachment_ids'],
        'work_id' => ['work_id'],
        'content' => ['content'],
        'comment_id' => ['comment_id'],
        'reason' => ['reason']
    ];
}