<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\cert;

use app\admin\controller\AdminBase;
use app\admin\validate\CertValidate;
use app\api\service\UtilService;
use app\model\Cert as CertModel;
use think\App;
use think\facade\Db;
use app\model\CertCategory;
use app\model\CertTag;

/**
 * 后台主控制器
 */
class Cert extends AdminBase
{

    protected $cert;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->cert = new CertModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];

            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['title', 'like', '%' . $post['kw'] . '%'];
            }
            if (isset($post['cate_id']) && !empty($post['cate_id'])) {
                $map[] = ['cate_id', '=', $post['cate_id']];
            }
            $list = $this->cert->where($map)->with(['certcatedata'])->append(['thumbpath','starttimetxt','endtimetxt'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }
        $category = CertCategory::field('*,pid as parentid')->where('is_del', 0)->order('sort desc')->select()->toArray();
        $this->assign('category', json_encode($category));
        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->cert->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if($result){
            return $this->returnMsg('修改成功',1);
        }else{
            return $this->returnMsg('修改失败');
        }
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->cert->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }



    //编辑新增
    public function edit()
    {
        $post = input();
        if ($this->request->isPost()) {

            $check = (new CertValidate())->goCheck();
            if ($check !== true) {
                return $check;
            }
            try {

                if ($post['id'] > 0) {
                    $msg = '更新成功';
                    $this->cert->update($post, ['id' => $post['id']]);
                } else {
                    $post['sn'] = UtilService::generateCompactOrderNo(0, 'SMBH');
                    $post['createtime'] = time();
                    unset($post['id']);
                    $msg = '添加成功';
                    $this->cert->save($post);
                }
            } catch (\Exception $e) {

                return $this->returnMsg($e->getMessage(), 0);
            }
            return $this->returnMsg($msg, 1);

        }
        $data = $this->cert->append(['starttimetxt','endtimetxt'])->where('id',$post['id'])->find();
        $data->content = json_encode($data->content);


        $catemodel = new CertCategory();
        $categorydata = $catemodel->catetree(isset($data['cate_id']) ? $data['cate_id'] : 0);
        $certtaglist = CertTag::where('is_del', 0)->select()->toArray();
        foreach ($certtaglist as &$v) {

            $v['label'] = $v['title'];
            $v['value'] = $v['id'];
            $v['children'] =[];
        }
        $this->assign('categorydata', $categorydata);
        $this->assign('certtaglist', json_encode($certtaglist));
        $this->assign('data', $data);
        return $this->fetch('', '', false);
    }

    //详情
    public function detail()
    {
        $post = input();
        $info = $this->cert->where('id', $post['id'])->find();
        $this->assign('info', $info);
        return $this->fetch('', '', false);
    }

}