<?php

namespace app\model\project;

use app\admin\controller\users\Smrz;
use app\model\Payment;
use app\model\system\SystemUploadFile;
use think\Model;
use function Symfony\Component\Translation\t;

class User extends Model
{

    protected $name = 'user';

    protected $autoWriteTimestamp = true;
    protected $createTime = 'create_time';
    protected $hidden = ['password', 'token', 'salt'];

    public function getSchoolData()
    {
        return $this->hasOne(School::class, 'user_id', 'id')->where('is_del',0);
    }

    public function getBusinessData()
    {
        return $this->hasOne(Business::class, 'user_id', 'id')->where('is_del',0);
    }

    public function headico()
    {
        return $this->hasOne(SystemUploadFile::class, 'fileid', 'headico')
            ->where('isdel',0)
            ->field('fileid,filename,filesize,fileurl,filetype,storage');
    }

    public function zfb()
    {
        return $this->hasOne(UserAccount::class, 'user_id', 'id')
            ->where('type',0)
            ->where('is_del',0)
            ->field('account,id,user_id,is_del');
    }

    //实名认证
    public function smrzinfo()
    {
        return $this->hasOne(UserSmrz::class, 'user_id', 'id')
            ->where('is_del',0)
//            ->where('status',2)
            ->field('id,realname,user_id,idcard');
    }
    //获取头像
    public function getHeadericourlAttr($value, $data)
    {
        return get_upload_file($data['headico']);
    }

    //获取性别
    public function getSexdataAttr($value, $data)
    {
        switch ($data['sex']) {
            case '1':
                $txt = '男';
                break;
            case '2':
                $txt = '女';
                break;
            default:
                $txt = '未知';
        }
        return $txt;
    }

    public function getRegTimeAttr($value, $data)
    {
        return date('Y-m-d H:i:s', $value);
    }
    public function getLastLoginTimeAttr($value, $data)
    {
        return date('Y-m-d H:i:s',$value);
    }

    //用户类型
    public function getRoletxtAttr($value, $data)
    {
        switch ($data['role']) {
            case '3':
                $txt = '高校用户';
                break;
            case '2':
                $txt = '企业用户';
                break;
            default:
                $txt = '普通用户';
        }
        return $txt;
    }

    public function student()
    {
        return $this->belongsTo(\app\model\project\User::class, 'id', 'user_id')
            ->field('id,title');
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    //实名信息
    public function userReal()
    {
        return $this->hasOne(UserSmrz::class, 'user_id', 'id')->where('is_del',0);
    }


}