<?php

namespace app\api\validate;

use think\Validate;

class ShCourseValidate extends BaseValidate
{
    protected $rule = [
        'course_id' => 'require',
        'updateField' => 'require|in:status,is_sell',
        'updateValue' => 'require',
        'title' => 'require',
        'cate_id' => 'require',
        'teacher_id' => 'require',
        'thumb' => 'require',
        'detailthumb' => 'require',
        'content' => 'require',
        'description' => 'require',

    ];

    protected $message = [
        'course_id.require' => '课程id不能为空',
        'updateField.require' => '必填项不能为空',
        'updateValue.require' => '必填项不能为空',
        'updateField.in' => '范围不合法',
        'title.require' => '课程名称不能为空',
        'cate_id.require' => '课程分类不能为空',
        'teacher_id.require' => '讲师不能为空',
        'thumb.require' => '封面图不能为空',
        'detailthumb.require' => '课程详情图不能为空',
        'description.require' => '课程简介不能为空',
        'content.require' => '课程内容不能为空'
    ];


}