<?php

namespace app\admin\validate;

use think\Validate;
use app\model;
use app\api\validate\BaseValidate;

class CertValidate extends BaseValidate
{

    protected $rule = [
        'title' => 'require',
        'cate_id' => 'require',
        'thumb_id' => 'require',
        'description' => 'require',
        // 'price' => 'require|between:0.01,999999.99',
        'start_time' => 'require',
        'end_time' => 'require',
        'content' => 'require',
    ];

    protected $message = [
        'title.require' => '文章标题不能为空',
        'cate_id.require' => '请选择分类',
        'thumb_id.require' => '请上传图片',
        'description.require' => '请输入证书简介',
        // 'price.require' => '请输入价格',
        // 'price.between' => '价格格式不对',
        'start_time.require' => '请输入报名开始时间',
        'end_time.require' => '请输入报名结束时间',
        'content.require' => '请输入内容',
    ];


}