<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\validate\CourseTeacherValidate;
use app\BaseController;
use app\Request;
use app\model\CourseTeacher as CourseTeacherModel;

class CourseTeacher extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //添加讲师
    public function createCourseTeacher(Request $request)
    {
        $vo = (new CourseTeacherValidate())->goCheck(['nickname']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $parm['createtime'] = time();
        $parm['user_id'] = $request->userId;
        $result = CourseTeacherModel::create($parm);
        return $this->returnMsg('操作成功', 1, $result);
    }

    //编辑讲师
    public function editCourseTeacher(Request $request)
    {

        $vo = (new CourseTeacherValidate())->goCheck(['teacher_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $updatedata = $parm;
        unset($updatedata['teacher_id']);
        $result = CourseTeacherModel::where(['user_id' => $request->userId, 'id' => $parm['teacher_id']])->update($updatedata);
        return $this->returnMsg('操作成功', 1, $result);
    }

    //删除讲师
    public function deleteCourseTeacher(Request $request)
    {

        $vo = (new CourseTeacherValidate())->goCheck(['teacher_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['id' => $parm['teacher_id'], 'user_id' => $request->userId];
        $result = CourseTeacherModel::where($where)->update(['is_del' => 1]);
        return $this->returnMsg('操作成功', 1, $result);
    }

    //讲师列表
    public function CourseTeacherList(Request $request)
    {
        $parm = $request->param();
        $map = [];
        if(isset($parm['searchnickname']) && $parm['searchnickname']){
            $map[] = ['nickname', 'like', '%' . $parm['searchnickname'] . '%'];
        }
        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);
        $where = ['is_del' => 0, 'user_id' => $request->userId];
        $list = CourseTeacherModel::where($where)->where($map)
            ->order('createtime desc')
            ->append(['thumbpath'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        return $this->returnMsg('success', 1, $list);
    }

    //讲师详情
    public function CourseTeacherDetail(Request $request)
    {
        $vo = (new CourseTeacherValidate())->goCheck(['teacher_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $info = CourseTeacherModel::find($parm['teacher_id'])->append(['thumbpath']);
        return $this->returnMsg('success', 1, $info);
    }

}