<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\users;

use app\admin\controller\AdminBase;
use app\admin\validate\UserExpRuleValidate;
use think\App;
use think\facade\Db;
use app\model\UserExpRule as UserExpRuleModel;

/**
 * 后台主控制器
 */
class UserExpRule extends AdminBase
{

    protected $userexprule;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->userexprule = new UserExpRuleModel();
    }
    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {
            $list = $this->userexprule->order('id asc')->select();
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->userexprule->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改失败');
        }
    }

    public function del()
    {
        $post = input();
//        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->userexprule->destroy($post['id'])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


}