<?php

namespace app\api\service;

use app\api\validate\UserValidate;
use app\model\project\User;
use app\model\project\User as userModel;
use app\Request;

class UserService
{

    public static function  getUserInfo($token)
    {

        $user = TokenService::verifyToken($token);
        if ($user===false)
        {
            return false;
        }
        $user = userModel::where(['token'=>$token,'is_del'=>0])
//            ->field('id,username,mobile,realname,token,role')
            ->with(['headico','zfb','userReal'])
            ->find();
        if (!$user)
        {
            return false;
        }

        return $user->toArray();
    }

    public static function updateUserInfo($filed,$value)
    {
        return User::where('id',\request()->userId)->update([$filed=>$value]);
    }

    public static function rankUserExperience($limit = 10, $timeRange = 'all')
    {
        // 基础查询
        $query = userModel
            ::field('id, username, realname, headico, experience')
            ->with(['headico'])
            ->where('is_del', 0)
            ->where('experience','>',0)
            ->order('experience', 'DESC')
            ->limit($limit);

        // 按时间范围筛选（如果需要基于注册时间筛选）
        switch ($timeRange) {
            case 'month':
                $query->whereTime('register_time', 'month');
                break;
            case 'week':
                $query->whereTime('register_time', 'week');
                break;
            case 'day':
                $query->whereTime('register_time', 'today');
                break;
            case 'three_month':
                $threeMonthAgo = strtotime('-3 months');
                $query->where('register_time', '>=', $threeMonthAgo);
                break;
        }

        $ranking = $query->select()->toArray();

        return $ranking;
    }

}