<?php

namespace app\api\service;

use think\facade\Cache;
use think\facade\Log;
use think\Response;


class WeChatLoginService
{

    // Token前缀
    const TOKEN_PREFIX = 'wechat_login_token:';
    // 过期时间(秒)
    const EXPIRE = 5400; // 1.5小时
    const appid = "wx24528a99c58e1919";
    const appsecret = "9ff78ed83a517231754217784eab29a6";

    //生成access_token
    public static function createAccessToken()
    {

        $cacheKey = self::TOKEN_PREFIX . self::appid;
        $accessToken = Cache::get($cacheKey);
        if ($accessToken) {
            return $accessToken;
        }
        $appid = self::appid;
        $appsecret = self::appsecret;

        $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$appid}&secret={$appsecret}";
        // 发送HTTP请求
        $response = http_get($url);
        $data = json_decode($response, true);
        if (isset($data['access_token']) && $data['access_token']) {
            // 存入缓存
            Cache::set($cacheKey, $data['access_token'], self::EXPIRE);
            return $data['access_token'];
        }
        throw new \Exception('access_token生成失败001');
    }

    //生成二维码
    public static function createerwm()
    {

        $accessToken = self::createAccessToken();

        if (!$accessToken) {
            throw new \Exception('access_token生成失败002');
        }
        $cachekey = 'wxlogin_' . md5(self::TOKEN_PREFIX . uniqid());
        $pram['expire_seconds'] = 500;
        $pram['action_name'] = 'QR_STR_SCENE';
        $pram['action_info']['scene'] = array(
            'scene_str' => $cachekey,
            'scene_id' => 1000
        );
        $url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" . $accessToken;
        $response = http_post($url, json_encode($pram, true));
        $data = json_decode($response, true);

        if (isset($data['ticket']) && $data['ticket']) {
            $ewmurl = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" . urlencode($data['ticket']);
            $returndata['cachekey'] = $cachekey;
            $returndata['ewmurl'] = $ewmurl;
            Cache::set($cachekey, $data['ticket'], 1000);
            return $returndata;
        }
        throw new \Exception('二维码获取失败');
    }

}