<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use think\facade\Db;
use think\Model;
use tool\Tree;

/**
 * 模型公用类
 */
class ArticleCategoryModel extends Model
{

    protected $name = 'article_category';

    public function catetree($cate_id = 0)
    {
        $map[] = ['is_del', '=', 0];
        $category = $this->where($map)->order('sort desc')->select()->toArray();

        $tree = new Tree();
        $tree->icon = ['&nbsp;&nbsp;│ ', '&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;└─ '];
        $tree->nbsp = '&nbsp;&nbsp;';
        $str = "<option value=@id @selected @disabled>@spacer @title</option>";
        $tree->init($category);
        $categorydata = $tree->getTree(0, $str, $cate_id);
        return $categorydata;
    }

    public function list(){
        $map[] = ['is_del', '=', 0];
        $category = $this->order('sort desc')->where($map)->select()->append(['typetxt','thumbpath'])->toArray();
        $tree       = new Tree();
        $tree->icon = ['&nbsp;&nbsp;│ ', '&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;└─ '];
        $tree->nbsp = '&nbsp;&nbsp;';
        $tree->init($category);
        $categorydata = $tree->getTreeList($tree->getTreeArray(0),'title');
        return $categorydata;
    }

    public function getTypetxtAttr($value,$data)
    {
        return $data['type'] == 'page' ? '单页' : '文章';
    }

    public function getThumbpathAttr($value, $data)
    {
        return get_upload_file($data['thumb']);
    }
}