<?php

namespace app\admin\controller\users;

use app\admin\controller\AdminBase;
use app\admin\validate\UserValidate;
use app\model\project\User as UserModel;
use app\model\project\UserSmrz;
use think\App;
use think\facade\Db;
use app\model\project\UserMoneyLog;

class User extends AdminBase
{
    protected $user;

    public function __construct(App $app)
    {
        parent::__construct($app);
        $this->user = new UserModel();

    }

    //会员列表
    public function index(string $do = '')
    {
        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['username|mobile|realname', 'like', '%' . $post['kw'] . '%'];
            }

            if (isset($post['role']) && !empty($post['role'])) {
                $map[] = ['role', '=', $post['role']];
            }


            $list = $this->user->where($map)->append(['headericourl', 'sexdata', 'roletxt'])->order('id desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        $this->assign('get', input());
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {
        $post = input();
        $result = $this->user->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改失败');
        }
    }

    //会员详情
    public function detail()
    {
        $post = input();
        $info = $this->user->find($post['id']);
        $smrzinfo = UserSmrz::where(['user_id' => $post['id'], 'status' => 2])->find();
        $this->assign('info', $info);
        $this->assign('smrzinfo', $smrzinfo);
        return $this->fetch('', '', false);
    }

    //资金记录
    public function usermoneylog()
    {
        $this->assign('limit', 10);
        $this->assign('user_id', request()->param('user_id'));
        return $this->fetch('', '', false);
    }


    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->user->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }

    //重置密码
    public function resetpwd()
    {
        $post = input();
        $user = $this->user->find($post['id']);
        $pwd = md5('ls123456' . $user['salt']);
        $result = $this->user->where('id', $post['id'])->update(['password' => $pwd]);
        if ($result) {
            return $this->returnMsg("成功", 1);
        } else {
            return $this->returnMsg("失败");
        }

    }

    //编辑余额
    public function editmoney()
    {
        $post = input();

        if ($this->request->isAjax()) {

            $vo = (new UserValidate())->goCheck(['user_id', 'change_money']);
            if ($vo !== true) {
                return $vo;
            }

            try {
                Db::startTrans();
                $userinfo = $this->user->lock(true)->find($post['user_id']);
                if ($userinfo['role'] == 1) {
                    if ($post['change_money'] < 0 && $userinfo['money'] < abs($post['change_money'])) {
                        Db::rollback();
                        throw new \Exception('余额不足');
                    }
                    //普通用户
                    $usermoney = $userinfo['money'];
                    $money_type = 0;
                    //增加余额
                    $res = $userinfo->setInc('money', $post['change_money']);
                } else {
                    if ($post['change_money'] < 0 && $userinfo['credit_money'] < abs($post['change_money'])) {
                        Db::rollback();
                        throw new \Exception('余额不足');
                    }

                    $usermoney = $userinfo['credit_money'];
                    $money_type = 1;
                    //增加信用分
                    $res = $userinfo->setInc('credit_money', $post['change_money']);
                }
                if (!$res) {
                    Db::rollback();
                    throw new \Exception('余额变动失败');
                }
                UserMoneyLog::addUserMoneyLog($userinfo['id'], $post['change_money'], $usermoney, 2, '后台调整金额', 0, $money_type);

                Db::commit();
                return $this->returnMsg("操作成功", 1);
            } catch (\Exception $e) {
                Db::rollback();
                return $this->returnMsg($e->getMessage());
            }

        }

        $user = $this->user->find($post['id']);
        $this->assign('user', $user);
        return $this->fetch('', '', false);

    }

}