<?php
/* *
 * 功能：支付宝电脑网站支付
 * 版本：2.0
 * 修改日期：2017-05-01
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 */

namespace app\api\service;


require_once ROOT_PATH . 'extend/aop/AopCertClient.php';
require_once ROOT_PATH . 'extend/aop/request/AlipayTradePagePayRequest.php';
require_once ROOT_PATH . 'extend/aop/request/AlipayTradeQueryRequest.php';

class AlipayTradeService
{

    public $appId = '';
    public $gatewayUrl = 'https://openapi.alipay.com/gateway.do';
    public $rsaPrivateKey;
    public $alipayCertPath; //支付宝公钥证书

    public $appCertPath; //应用公钥证书
    public $rootCertPath; //支付宝根证书
    public $apiVersion = '1.0';
    public $signType = 'RSA2';
    public $postCharset = 'utf-8';
    public $format = 'json';
    public $NotifyUrl = ''; //后台回调
    public $ReturnUrl = ''; //前台回调 支付成功页面

    public function __construct()
    {
        $cofig = config('pay.alipay.default');
        $this->appCertPath = $this->appCertPath ?: $cofig['appCertPath'];
        $this->rootCertPath = $this->rootCertPath ?: $cofig['rootCertPath'];
        $this->alipayCertPath = $this->alipayCertPath ?: $cofig['alipayCertPath'];
        $this->rsaPrivateKey = $this->rsaPrivateKey ?: $cofig['rsaPrivateKey'];
        $this->appId = $this->appId ?: $cofig['appId'];
    }


    //pc网站支付
    public function pcpaypage($biz_content)
    {
        //3、pageExecute 测试
        $aop = new \AopCertClient ();
//        $appCertPath = ROOT_PATH . 'cert/zfbcert/appCertPublicKey.crt';
//        $alipayCertPath = ROOT_PATH . 'cert/zfbcert//alipayCertPublicKey_RSA2.crt';
//        $rootCertPath = ROOT_PATH . 'cert/zfbcert//alipayRootCert.crt';
        $aop->gatewayUrl = $this->gatewayUrl;
        $aop->appId = $this->appId;
        $aop->rsaPrivateKey = $this->rsaPrivateKey;
        $aop->alipayrsaPublicKey = $aop->getPublicKey($this->alipayCertPath);
        $aop->apiVersion = $this->apiVersion;
        $aop->signType = $this->signType;
        $aop->postCharset = $this->postCharset;
        $aop->format = $this->format;
        $aop->isCheckAlipayPublicCert = true;//是否校验自动下载的支付宝公钥证书，如果开启校验要保证支付宝根证书在有效期内
        $aop->appCertSN = $aop->getCertSN($this->appCertPath);//调用getCertSN获取证书序列号
        $aop->alipayRootCertSN = $aop->getRootCertSN($this->rootCertPath);//调用getRootCertSN获取支付宝根证书序列号
        $request = new \AlipayTradePagePayRequest ();
        $request->setNotifyUrl($this->NotifyUrl);
        $request->setReturnUrl($this->ReturnUrl);
        $biz_content = json_encode($biz_content, JSON_UNESCAPED_UNICODE);
        $request->setBizContent($biz_content);
        $result = $aop->pageExecute($request);
        return $result;
    }


    //交易查询
    public function payquery($biz_content)
    {
        $aop = new \AopCertClient();
        $aop->gatewayUrl = 'https://openapi.alipay.com/gateway.do';
        $aop->appId = $this->appId;
        $aop->rsaPrivateKey = $this->rsaPrivateKey;
        $aop->alipayrsaPublicKey = $aop->getPublicKey($this->alipayCertPath);
        $aop->apiVersion = $this->apiVersion;
        $aop->signType = $this->signType;
        $aop->postCharset = $this->postCharset;
        $aop->format = $this->format;
        $aop->isCheckAlipayPublicCert = true;//是否校验自动下载的支付宝公钥证书，如果开启校验要保证支付宝根证书在有效期内
        $aop->appCertSN = $aop->getCertSN($this->appCertPath);//调用getCertSN获取证书序列号
        $aop->alipayRootCertSN = $aop->getRootCertSN($this->rootCertPath);//调用getRootCertSN获取支付宝根证书序列号
        $request = new \AlipayTradeQueryRequest ();
        $request->setNotifyUrl($this->NotifyUrl);
        $request->setReturnUrl($this->ReturnUrl);
        $biz_content = json_encode($biz_content, JSON_UNESCAPED_UNICODE);
        $request->setBizContent($biz_content);
        $result = $aop->execute($request);
        return $result->alipay_trade_query_response;

    }

    /**
     * 验签方法
     * @param $arr 验签支付宝返回的信息，使用支付宝公钥。
     * @return boolean
     */
    public function check($arr)
    {
        $aop = new \AopCertClient();
        $aop->alipayPublicKey = $this->alipayCertPath;
        $result = $aop->rsaCheckV1($arr, $this->alipayCertPath, $this->signType);
        return $result;
    }

}

?>