<?php

namespace app\api\controller\mine;

use app\api\middleware\Auth;
use app\api\service\UserService;
use app\api\validate\CourseValidate;
use app\BaseController;
use app\model\CourseUserWork;
use app\Request;

class Work extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];


    /**我的作业列表
     * @param Request $request
     * @return \app\html
     */
    public function workList(Request $request)
    {

        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);

        $workList = CourseUserWork::workList($request->userId, $page, $pageSize);

        return $this->returnMsg('success',1,$workList);

    }

    /**我的作业详情
     * @param Request $request
     * @return \app\html
     */
    public function workDetail(Request $request)
    {

        $workId = $request->param('workId');

        $detail = CourseUserWork::workDetail($workId);

        return $this->returnMsg('success',1,$detail);

    }

    /**上传作业
     * @param Request $request
     * @return \app\html
     */
    public function uploadWork(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['attachment_ids','work_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $uploadWork = CourseUserWork::uploadWork($data['work_id'],$data['attachment_ids']);

        return $this->returnMsg('success',1,$uploadWork);

    }

}