<?php

namespace app\api\service;

class UtilService
{
//    public static function generateOrderNo($userId = 0,$str=null)
//    {
//        $microtime = microtime(true);
//        $timestamp = date('YmdHis') . substr($microtime, 11, 3);
//
//
//        $random = str_pad(mt_rand(0, 999999), 6, '0', STR_PAD_LEFT);
//
//
//        $userPart = $userId ? substr(str_pad($userId, 4, '0', STR_PAD_LEFT), -4) : '';
//
//
//        return $str.'-'. $timestamp . $random . ($userPart ? ('-' . $userPart) : '');
//    }

    public static function generateCompactOrderNo($userId = null,$str=null)
    {
        $time = substr(time(), -6); // 取时间戳后6位
        $rand = mt_rand(100000, 999999); // 6位随机数
        $user = $userId ? chr(65 + ($userId % 26)) : ''; // 用户标识转A-Z

        return $str . $user . $time . $rand;
    }

    public static function listWithTags($list, string $modelClass, string $tagIdsField = 'tag_ids'): array
    {
        $allTagIds = [];
        foreach ($list->items() as $item) {
            if (!empty($item->{$tagIdsField})) {
                $tagIds = explode(',', $item->{$tagIdsField});
                $allTagIds = array_merge($allTagIds, $tagIds);
            }
        }

        $tags = [];
        if (!empty($allTagIds)) {
            $tags = $modelClass::where('is_del', 0)
                ->whereIn('id', array_unique($allTagIds))
                ->field('id,title')
                ->select()
                ->toArray();
            $tags = array_column($tags, null, 'id');
        }

        $result = $list->toArray();
        foreach ($result['data'] as &$item) {
            $itemTags = [];
            if (!empty($item[$tagIdsField])) {
                $tagIds = explode(',', $item[$tagIdsField]);
                foreach ($tagIds as $tagId) {
                    if (isset($tags[$tagId])) {
                        $itemTags[] = $tags[$tagId];
                    }
                }
            }
            $item['tags'] = $itemTags;
        }

        return $result;
    }
}