<?php

namespace app\admin\controller\users;

use app\admin\controller\AdminBase;
use app\model\project\User as UserModel;
use app\model\project\UserSmrz;
use think\App;

class User extends AdminBase
{
    protected $user;

    public function __construct(App $app)
    {
        parent::__construct($app);
        $this->user = new UserModel();

    }

    //会员列表
    public function index(string $do = '')
    {
        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['is_del', '=', 0];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $map[] = ['username|mobile|realname', 'like', '%' . $post['kw'] . '%'];
            }

            $list = $this->user->where($map)->append(['headericourl', 'sexdata', 'roletxt'])->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        $this->assign('get', input());
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {
        $post = input();
        $result = $this->user->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改失败');
        }
    }

    //会员详情
    public function detail()
    {
        $post = input();
        $info = $this->user->where('id', $post['id'])->find();
        $smrzinfo = UserSmrz::where(['user_id' => $post['id'], 'status' => 2])->find();
        $this->assign('info', $info);
        $this->assign('smrzinfo', $smrzinfo);
        return $this->fetch('', '', false);
    }

    //会员详情
    public function usermoneylog()
    {
        $this->assign('limit', 10);
        $this->assign('user_id', request()->param('user_id'));
        return $this->fetch('', '', false);
    }


    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->user->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }

    //重置密码
    public function resetpwd()
    {
        $post = input();
        $user = $this->user->find($post['id']);
        $pwd = md5('123456' . $user['salt']);
        $result = $this->user->where('id', $post['id'])->update(['password' => $pwd]);
        if ($result) {
            return $this->returnMsg("成功", 1);
        } else {
            return $this->returnMsg("失败");
        }

    }


}