<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use app\api\service\UtilService;
use \app\model\CertCategory;
use app\model\project\User;
use app\model\system\SystemUploadFile;
use think\facade\Db;
use think\Model;

/**
 * 课程模型
 */
class Payment extends Model
{

    protected $autoWriteTimestamp = true;
    protected $createTime = 'createtime';


    //用户信息
    public function getuserdata()
    {
        return $this->belongsTo(User::class, 'user_id')
            ->field('username,mobile,id');
    }

    public function getPayMethodTextAttr($value, $data)
    {
        switch ($data['pay_method']) {
            case 2:
                $text = '微信';
                break;
            default:
                $text = '支付宝';
                break;
        }
        return $text;
    }

    public function getPayStatusTextAttr($value, $data)
    {
        switch ($data['pay_status']) {
            case 1:
                $text = '支付成功';
                break;
            case 2:
                $text = '支付失败';
                break;
            default:
                $text = '未支付';
                break;
        }
        return $text;
    }

    public function getPayTimeTextAttr($value, $data)
    {
        return date('Y-m-d H:i:s', $data['pay_time']);

    }

    public function getOrderNameAttr($value, $data)
    {
        $title = '';
        if ($data['order_type'] == 1) {
            //课程
            $title = ShCourse::where('id', $data['order_id'])->value('title');
            $title = '购买课程：' . $title;
        } elseif ($data['order_type'] == 2) {
            //证书
            $certinfo = CertOrder::where('id', $data['order_id'])->with('certdata')->find();
            $title = '购买证书：' . $certinfo['certdata']['title'];
        }
        return $title;
    }

}