<?php

namespace app\api\controller\project;

use app\api\service\UserService;
use app\api\validate\ProjectValidate;
use app\BaseController;
use app\model\project\UserMoneyLog;
use think\Request;
use app\model\ProjectCategory;
use app\model\Project as ProjectModel;

class Project extends BaseController
{
    //项目分类列表
    public function getProjectCategoryList()
    {
        $list = (new ProjectCategory())->getProjectCategoryList();

        return $this->returnMsg('success',1,$list);
    }

    //项目列表
    public function getProjectList(Request $request)
    {
        $vo = (new ProjectValidate())->goCheck(['category_id','type']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $list = (new ProjectModel())->getProjectList($data['category_id'],$page,$pageSize,$data['type']);

        return $this->returnMsg('success',1,$list);
    }

    public function rankProjectList(Request $request)
    {

        $limit = $request->param('limit/d', 1);
        $type = $request->param('type', 'day');


        $list = UserMoneyLog::getUserMoneyRanking($limit,$type,0);

        return $this->returnMsg('success',1,$list);

    }

    public function getProjectDetail(Request $request)
    {

        $vo = (new ProjectValidate())->goCheck(['project_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();
        $userId = 0;

        $token = $request->header('token');
        if ($token)
        {
            $userId = UserService::getUserInfo($token)['id'];
        }


        $detail = (new ProjectModel())->projectDetail($data['project_id'],$userId);

        return $this->returnMsg('success',1,$detail);

    }



}