<?php

namespace app\api\controller;

use app\api\middleware\Auth;
use app\api\service\UtilService;
use app\model\CourseTeacher;
use app\Request;
use app\api\validate\CourseValidate;
use app\BaseController;
use app\model\Course as CourseModel;
use app\model\CourseCategory as CourseCategoryModel;

class Course extends BaseController
{

    /**获取推荐课程列表
     * @return \app\html
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getRecommendList()
    {
        $list = (new CourseModel())->getRecommendList();

        return $this->returnMsg('success',1,$list);
    }

    /**获取课程分类列表
     * @return \app\html
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getCourseCategoryList()
    {
        $list = (new CourseCategoryModel())->getCourseCategoryList();

        return $this->returnMsg('success',1,$list);
    }

    /**课程搜索
     * @param Request $request
     * @return \app\html|\think\response\Json|true
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function searchCourse(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['searchKeyWords']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $where = ['status'=>3,'is_sell'=>1,'is_del'=>0];
        $list = CourseModel::where($where)
            ->where('title', 'like', '%' . $data['searchKeyWords'] . '%')
            ->field('id,thumb,title,createtime,description,price,content')
            ->select();

        return $this->returnMsg('success',1,$list);

    }


    /**获取分类下的课程列表
     * @param Request $request
     * @return \app\html|\think\response\Json|true
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getCourseList(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['category_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $page = $request->param('page/d', 1);
        $pageSize = $request->param('pageSize/d', 10);

        $list = (new CourseModel())->getCourseList($data['category_id'],$page,$pageSize);

        return $this->returnMsg('success',1,$list);

    }


    /**获取课程详情
     * @param Request $request
     * @return \app\html|\think\response\Json|true
     */

    public function getCourseDetail(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['course_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $data = (new CourseModel())
//            ->with(['getTeacher','getSections'=>['getCourseClass'],'getCourseClass'])
            ->getCouresDetail($data['course_id']);
        CourseModel::where('id',$data['course_id'])->inc('click')->update([]);

        return $this->returnMsg('success',1,$data);

    }

    /**获取课程章节目录课时
     * @param Request $request
     * @return \app\html|\think\response\Json|true
     */
    public function getCoureseClassList(Request $request)
    {
        $vo = (new CourseValidate())->goCheck(['course_id']);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->param();

        $data = (new CourseModel())
            ->with(['getSections'=>['getCourseClass'],'getCourseClass'])
            ->where('id',$data['course_id'])
            ->field('id,thumb,title,createtime,description,price,content,teacher_id,tvclick,click')
            ->find();

        return $this->returnMsg('success',1,$data);
    }





}