<?php
namespace app\model;

use app\model\project\User;
use think\Model;
use think\model\concern\SoftDelete;

class CourseComment extends Model
{
    use SoftDelete;

    // 设置当前模型对应的完整数据表名称
    protected $table = 'fj_course_comments';

    // 自动时间戳
    protected $autoWriteTimestamp = true;
    protected $createTime = 'createtime';
    protected $updateTime = 'updatetime';


    // 指定软删除字段
    protected $deleteTime = 'deletetime';

    // 用户关联
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')
            ->field('id,username,headico');
    }

    // 回复关联
    public function replies()
    {
        return $this->hasMany(CourseComment::class, 'parent_id', 'id')
            ->with('user')
            ->order('createtime', 'asc');
    }

    // 获取课程评论列表
    public static function getCommentList($courseId, $page = 1, $pageSize = 10)
    {
        return self::with(['user'=>['headico'], 'replies'])
            ->where('course_id', $courseId)
            ->where('parent_id', 0)
            ->order('createtime', 'desc')
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
    }

    // 获取包含已删除评论的查询（管理员用）
    public static function getListWithTrashed($courseId)
    {
        return self::with(['user'=>['headico'], 'replies'])
            ->where('course_id', $courseId)
            ->where('parent_id', 0)
            ->withTrashed()
            ->select();
    }
}