<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\model;

use think\facade\Db;
use think\Model;
use think\model\concern\SoftDelete;
use tool\Tree;

/**
 * 模型公用类
 */
class ProjectCategory extends Model
{
    use SoftDelete;
    protected $deleteTime = 'deletetime';

    protected $autoWriteTimestamp = true;
    protected $createTime = 'createtime';


    public function catetree($cate_id = 0)
    {

        $category = $this->order('sort desc')->select()->toArray();

        $tree = new Tree();
        $tree->icon = ['&nbsp;&nbsp;│ ', '&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;└─ '];
        $tree->nbsp = '&nbsp;&nbsp;';
        $str = "<option value=@id @selected @disabled>@spacer @title</option>";
        $tree->init($category);
        $categorydata = $tree->getTree(0, $str, $cate_id);
        return $categorydata;
    }
    public function getThumbpathAttr($value, $data)
    {
        return get_upload_file($data['thumb']);
    }

    public function children()
    {
        return $this->hasMany(ProjectCategory::class, 'pid');
    }

    public function getProjectCategoryList()
    {
        return $this->with(['children' => function($query)  {
                $query->order('sort', 'asc');
            }])
            ->where('pid', 0)
            ->order('sort', 'asc')
            ->select();

    }



}