<?php

namespace app\api\validate;

use app\model\CourseTag;
use app\Request;
use think\Validate;

class CourseTagValidate extends BaseValidate
{

    protected $rule = [
        'title' => 'require|checktitle'
    ];
    protected $message = [
        'title.require' => '标签名不能为空',
        'title.checktitle' => '标签名重复',
    ];

    protected function checktitle($value, $rule, $data=[])
    {

        $uesrid = request()->userId;
        $result = CourseTag::where(['title' => $value, 'user_id' => $uesrid,'is_del'=>0])->count();
        if ($result) return false;

        return true;
    }


}