<?php

namespace app\api\validate;

use think\exception\ValidateException;
use think\Validate;

class BaseValidate extends Validate
{


    /**
     * 验证数据
     */

    public function goCheck($fields = [], $data = null)
    {
        $data = $data ?: request()->param();
        $header = request()->header();
        $data = array_merge($data, $header);

        // 如果指定了字段，只验证这些字段
        if (!empty($fields)) {
            $this->only($fields);
        }

        if (!$this->check($data)) {
//            throw new ValidateException($this->getError());
            return json([
                'msg'  => $this->getError(),
                'code' => 0,
                'data' => [
                    'errors' => $this->getError()
                ]
            ]);
        }
        return true;
    }

    /**
     * 验证ID是否为正整数
     */
    protected function isPositiveInteger($value)
    {
        return is_numeric($value) && is_int($value + 0) && ($value + 0) > 0;
    }

    /**
     * 验证手机号
     */
    protected function isMobile($value)
    {
        return preg_match('/^1[3-9]\d{9}$/', $value);
    }


}