<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\BaseController;
use app\model\StudyInformation as StudyInformationModel;
use app\model\StudyCategory;
use app\Request;
use think\facade\Db;
use app\api\validate\StudyInformationValidate;

class StudyInformation extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];

    //添加学习资料
    public function addStudyInformation(Request $request)
    {
        $filed = ['title', 'type', 'file_id', 'content', 'price', 'cate_id', 'description'];
        $vo = (new StudyInformationValidate())->goCheck($filed);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->only($filed);
        $data['user_id'] = $request->userId;
        $result = StudyInformationModel::create($data);
        return $this->returnMsg('操作成功', 1, $result);
    }

    /*
     * 编辑学习资料
     */
    public function editStudyInformation(Request $request)
    {
        $filed = ['study_information_id', 'title', 'type', 'file_id', 'content', 'price', 'cate_id', 'description'];
        $vo = (new StudyInformationValidate())->goCheck($filed);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $info = StudyInformationModel::where(['id' => $parm['study_information_id'], 'user_id' => $request->userId])->find();
        if ($info['status'] == 2) {
            return $this->returnMsg('已审核不能编辑');
        }
        $udpatedata = $request->only($filed);
        unset($udpatedata['study_information_id']);
        $result = $info->save($udpatedata);
        return $this->returnMsg('操作成功', 1, $result);
    }

    //删除学习资料
    public function deleteStudyInformation(Request $request)
    {

        $filed = ['study_information_id'];
        $vo = (new StudyInformationValidate())->goCheck($filed);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $info = StudyInformationModel::where(['id' => $parm['study_information_id'], 'user_id' => $request->userId])->find();
        if (empty($info)) {
            return $this->returnMsg('不存在或无权删除');
        }
        $result = $info->delete();
        return $this->returnMsg('操作成功', 1, $result);
    }

    //学习资料列表
    public function listStudyInformation(Request $request)
    {

        $parm = $request->param();
        $where = ['user_id' => $request->userId];
        $map = [];
        if (isset($parm['searchKeyWords']) && $parm['searchKeyWords']) {
            $map[] = ['title', 'like', '%' . $parm['searchKeyWords'] . '%'];
        }
        if (isset($parm['status']) && ($parm['status'] || $parm['status'] === '0')) {
            $map[] = ['status', '=', $parm['status']];
        }
        if (isset($parm['cate_id']) && $parm['cate_id']) {
            $map[] = ['cate_id', '=', $parm['cate_id']];
        }

        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 10);
        $list = StudyInformationModel::where($where)->where($map)
            ->order('createtime desc')
            ->with(['filepath', 'studycatedata'])
            ->append(['status_text'])
            ->paginate([
                'page' => $page,
                'list_rows' => $pageSize
            ]);
        return $this->returnMsg('success', 1, $list);

    }


    //修改学习资料属性
    public function updatestudyinfomationinfo(Request $request)
    {
        $vo = (new StudyInformationValidate())->goCheck(['study_information_id', 'updateField', 'updateValue']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['id' => $parm['study_information_id'], 'user_id' => $request->userId];
        if ($parm['updateField'] == 'is_sell') {
            $status = StudyInformationModel::where($where)->value('status');
            if ($status != 2) {
                return $this->returnMsg('审核未通过不能上下架');
            }
        }
        $result = StudyInformationModel::where($where)->update([$parm['updateField'] => $parm['updateValue']]);
        return $this->returnMsg('操作成功', 1, $result);
    }

    //学习资料详情
    public function detailStudyInformation(Request $request)
    {

        $vo = (new StudyInformationValidate())->goCheck(['study_information_id']);
        if ($vo !== true) {
            return $vo;
        }
        $parm = $request->param();
        $where = ['id' => $parm['study_information_id'], 'user_id' => $request->userId];
        $info = StudyInformationModel::where($where)->with(['filepath', 'studycatedata'])->append(['status_text'])->find();
        return $this->returnMsg('操作成功', 1, $info);
    }

    //学习资料分类列表
    public function getStudyCategoryList()
    {
        $list = (new StudyCategory)->getStudyCategoryList();
        return $this->returnMsg('操作成功', 1, $list);

    }

}