<?php
/**
 * ===========================================================================
 * Veitool 快捷开发框架系统
 * Author: Niaho 26843818@qq.com
 * Copyright (c)2019-2025 www.veitool.com All rights reserved.
 * Licensed: 这不是一个自由软件，不允许对程序代码以任何形式任何目的的再发行
 * ---------------------------------------------------------------------------
 */

namespace app\admin\controller\cert;

use app\admin\controller\AdminBase;
use app\event\PhpOffice;
use app\model\CertOrder as CertOrderModel;
use app\model\CertOrderAddress;
use app\model\project\Mail;
use think\App;

/**
 * 后台主控制器
 */
class CertOrder extends AdminBase
{

    protected $certorder;

    public function __construct(App $app)
    {
        parent::__construct($app);

        $this->certorder = new CertOrderModel();

    }

    // 列表
    public function index(string $do = '')
    {

        $limit = 10;
        if ($do == 'json') {

            $post = input();
            $post['limit'] = isset($post['limit']) ? $post['limit'] : $limit;
            $map[] = ['cert_order.is_del', '=', 0];
            $map[] = ['cert_order.status', '>', 0];
            $hasmap = [];
            if (isset($post['kw']) && !empty($post['kw'])) {
                $hasmap[] = ['user.username|user.mobile', 'like', '%' . $post['kw'] . '%'];
            }
            $certmap = [];
            if (isset($post['cert_title']) && !empty($post['cert_title'])) {
                $certmap[] = ['cert.title', 'like', '%' . trim($post['cert_title']) . '%'];
            }
            if (isset($post['ff_type']) && !empty($post['ff_type'])) {
                $certmap[] = ['cert.ff_type', '=', $post['ff_type'] - 1];
            }
            if (isset($post['status']) && !empty($post['status'])) {
                $map[] = ['status', '=', $post['status']];
            }
            $list = $this->certorder->hasWhere('userprofile', $hasmap)->hasWhere('certdata', $certmap)->where($map)->with(['certdata', 'userprofile', 'certfiledata'])->append(['status_text'])->order('createtime desc')->paginate($post['limit']);
            return $this->returnMsg($list);
        }

        $this->assign('limit', $limit);
        return $this->fetch('', '', false);
    }

    //快速编辑
    public function editup()
    {

        $post = input();
        $result = $this->certorder->update([$post['af'] => $post['av']], [['id', '=', $post['id']]]);
        if ($result) {
            return $this->returnMsg('修改成功', 1);
        } else {
            return $this->returnMsg('修改成功');
        }
    }

    public function del()
    {
        $post = input();
        $ids = is_array($post['id']) ? implode(',', $post['id']) : $post['id'];
        if ($this->certorder->where("id IN(" . $ids . ")")->update(['is_del' => 1])) {
            return $this->returnMsg("删除成功", 1);
        } else {
            return $this->returnMsg("删除失败");
        }
    }


    //审核
    public function shenhecertorder()
    {
        $post = input();
        $errordesc = '';
        $shstatus = 3;
        if ($post['shstatus'] == 2) {
            if (empty($post['errordesc'])) {
                return $this->returnMsg("请输入失败原因");
            }
            $len = mb_strlen($post['errordesc'], 'UTF-8');
            if($len > 200){
                return $this->returnMsg("失败原因长度不能超过200字");
            }
            $errordesc = $post['errordesc'];
            $shstatus = 2;
        }

        $updatedata['status'] = $shstatus;
        $updatedata['status_desc'] = $errordesc;

        $result = $this->certorder->where('id', $post['id'])->update($updatedata);
        if ($result) {
            $cert_order_info = $this->certorder->where('id', $post['id'])->with(['certdata'])->find();
            if ($post['shstatus'] == 1) {
                Mail::createmail($cert_order_info['user_id'], "您报名的证书【" . $cert_order_info['certdata']['title'] . "】已审核通过");
            } else {
                Mail::createmail($cert_order_info['user_id'], "您报名的证书【" . $cert_order_info['certdata']['title'] . "】审核不通过 - " . $errordesc);
            }
            return $this->returnMsg("操作成功", 1);
        } else {
            return $this->returnMsg("操作失败");
        }

    }


    //详情
    public function detail()
    {
        $post = input();
        $info = $this->certorder->with(['certdata', 'userprofile'])->append(['status_text'])->where('id', $post['id'])->find();
        $this->assign('info', $info);
        return $this->fetch('', '', false);
    }

    public function certaddress()
    {
        $post = input();
        $info = CertOrderAddress::where('cert_order_id', $post['cert_order_id'])->find();
        $this->assign('info', $info);
        return $this->fetch('', '', false);
    }


    //导出excel
    public function excelcertorder()
    {
        $post = input();
        $map[] = ['cert_order.is_del', '=', 0];
        $map[] = ['cert_order.status', '>', 0];
        $hasmap = [];
        if (isset($post['kw']) && !empty($post['kw'])) {
            $hasmap[] = ['user.username|user.mobile', 'like', '%' . $post['kw'] . '%'];
        }
        $certmap = [];
        if (isset($post['cert_title']) && !empty($post['cert_title'])) {
            $certmap[] = ['cert.title', 'like', '%' . trim($post['cert_title']) . '%'];
        }
        if (isset($post['ff_type']) && !empty($post['ff_type'])) {
            $certmap[] = ['cert.ff_type', '=', $post['ff_type'] - 1];
        }
        if (isset($post['status']) && !empty($post['status'])) {
            $map[] = ['status', '=', $post['status']];
        }

        try {
            $list = $this->certorder->hasWhere('userprofile', $hasmap)->hasWhere('certdata', $certmap)->where($map)->with(['certdata', 'userprofile', 'certorderaddress'])->append(['status_text'])->order('createtime desc')->select()->toArray();
            if (empty($list)) {
                throw new \Exception('没有数据');
            }
            $exceldata[] = ['用户名', '用户手机', '证书名称', '发放方式', '状态', '报名姓名', '报名身份证号码', '报名手机号', '报名邮箱', '时间', '收货人', '收货人联系方式', '详细地址'];
            foreach ($list as $v) {
                $exceldata[] = [
                    $v['userprofile']['username'],
                    $v['userprofile']['mobile'],
                    $v['certdata']['title'],
                    ($v['certdata']['ff_type'] == 1 ? '邮寄' : '线上'),
                    $v['status_text'],
                    $v['name'],
                    $v['idcard'],
                    $v['mobile'],
                    $v['email'],
                    $v['createtime'],
                    (isset($v['certorderaddress']['nickname']) ? $v['certorderaddress']['nickname'] : ''),
                    (isset($v['certorderaddress']['mobile']) ? $v['certorderaddress']['mobile'] : ''),
                    (isset($v['certorderaddress']['detail_address']) ? $v['certorderaddress']['detail_address'] : '')
                ];
            }

            $excelid = PhpOffice::exportexcel($exceldata, '证书报名导出');
            $data['url'] = '/admin/cert.cert_order/downloadfile?excel=1&fileid=' . $excelid;
            return $this->returnMsg('success', 1, $data);
        } catch (\Exception $e) {
            return $this->returnMsg($e->getMessage());
        }

    }
}