<?php

namespace app\api\controller\cert;

use app\api\middleware\Auth;
use app\api\service\UtilService;
use app\api\validate\CertValidate;
use app\BaseController;
use think\queue\Queueable;
use think\Request;
use app\model\CertOrder as OrderModel;

class CertOrder extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];


    //报名
    public function enrollCert(Request $request)
    {
        $allowArray = ['cert_id','name','idcard','idcard_q','idcard_h','mobile','email','head_img_id','other_file_id','pay_type'];

        $vo = (new CertValidate())->goCheck($allowArray);
        if ($vo !== true) {
            return $vo;
        }
        $data = $request->only($allowArray);

        $data['user_id'] = $request->userId;
        $data['createtime'] = time();
//        $data['order_sn'] = UtilService::generateOrderNo($request->userId,'cert');1

        unset($data['pay_type']);

        $userRole = UtilService::checkUserRole($data['user_id']);
        if ($userRole!=1)
        {
            return json(['code' => 0, 'msg' => '企业账号不能报名']);
        }

        $where = ['is_del'=>0,'user_id'=>$data['user_id'],'cert_id'=>$data['cert_id']];
        $count = OrderModel::where($where)->where('status','in',[1,3])->count();
        if ($count > 0) {
            return $this->returnMsg('请勿重复提交');
        }

        //免费证书
        $certData = \app\model\Cert::where('id',$data['cert_id'])->find();
        if ($certData['price']<=0)
        {
            //申请中
            $data['status'] = 1;
        }

        $enrollCert = OrderModel::create($data);

        return $this->returnMsg('success',1,$enrollCert);

    }

}