<?php

namespace app\api\controller\manage;

use app\api\middleware\Auth;
use app\api\service\UtilService;
use app\api\validate\BusinessValidate;
use app\BaseController;
use app\model\project\School;
use app\Request;
use think\facade\Db;
use app\model\project\User as UserModel;
use app\model\project\Business;

class User extends BaseController
{

    protected $middleware = [
        Auth::class,
    ];


    //获取企业信息
    public function getBusinessInfo(Request $request)
    {

        $info = Business::where(['user_id' => $request->userId, 'is_del' => '0'])
            ->with(['businessQualification', 'businessfrsfzqian', 'businessfrsfzhou'])
            ->find();
        return $this->returnMsg('操作成功', 1, $info);

    }

    //获取学校信息
    public function getSchoolInfo(Request $request)
    {

        $info = School::where(['user_id' => $request->userId, 'is_del' => '0'])
            ->with(['schoolQualification', 'schoolfrsfzqian', 'schoolfrsfzhou'])
            ->find();
        return $this->returnMsg('操作成功', 1, $info);

    }

    //修改企业信息
    public function editBusinessInfo(Request $request)
    {
        $filed = ['frxm', 'qydm', 'frsfz', 'business_qualification_url_id','frsfz_qian','frsfz_hou','contacts_name','contacts_phone','contacts_email'];
//        $vo = (new BusinessValidate())->goCheck(['frxm', 'qydm', 'frsfz', 'business_qualification_url_id']);
//        if ($vo !== true) {
//            return $vo;
//        }
        $updatedata = $request->only($filed);
        $result = Business::where(['user_id' => $request->userId, 'is_del' => '0'])->update($updatedata);
        return $this->returnMsg('操作成功', 1, $result);

    }

    //修改学校信息
    public function editSchoolInfo(Request $request)
    {
        $filed = ['frxm', 'qydm', 'frsfz', 'school_qualification_url_id','frsfz_qian','frsfz_hou','contacts_name','contacts_phone','contacts_email'];
//        $vo = (new BusinessValidate())->goCheck(['frxm', 'qydm', 'frsfz', 'business_qualification_url_id']);
//        if ($vo !== true) {
//            return $vo;
//        }
        $updatedata = $request->only($filed);
        $result = School::where(['user_id' => $request->userId, 'is_del' => '0'])->update($updatedata);
        return $this->returnMsg('操作成功', 1, $result);

    }

}